#include "GetObjects.js"

function DoScale( factoryname, getoriginframe, requireref1 )
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowEditPoints();
	
	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectObjectsPrompt' );
	moi.ui.hideUI( 'done' );	
	moi.ui.showUI( 'OriginPrompt' );
	
	if ( !getoriginframe )
		moi.ui.showUI( 'OriginOptions' );
	
	moi.ui.showUI( 'ScaleOptions' );
	moi.ui.endUIUpdate();

	var originpt;

	var pointpicker = moi.ui.createPointPicker();
	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return;
			
		if ( pointpicker.event == 'finished' )
		{
			originpt = pointpicker.pt;
			break;
		}
			
		if ( !getoriginframe && pointpicker.event == 'BoundingBoxCenter' )
		{
			originpt = objects.getHighAccuracyBoundingBox().center;
			moi.ui.addPickedPoint( originpt );
			break;
		}		
	}
	
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'OriginPrompt' );
	
	if ( !getoriginframe )
		moi.ui.hideUI( 'OriginOptions' );
	
	moi.ui.showUI( 'FirstRefPrompt' );
	
	if ( !requireref1 )
		moi.ui.showUI( 'ScaleFactorOptions' );

	moi.ui.endUIUpdate();


	pointpicker.restrictToPlaneThroughPt( originpt, false );
	pointpicker.stickToSurfacesMode = 'none';

	var input1 = getoriginframe ? pointpicker.ptframe : originpt;

	var factory = moi.command.createFactory( factoryname );
	factory.setInput( 0, objects );	
	factory.setInput( 1, input1 );
	
	var ref1linefactory = moi.command.createFactory( 'line' );
	ref1linefactory.setInput( 0, originpt );

	var ref2linefactory = moi.command.createFactory( 'line' );
	ref2linefactory.setInput( 0, originpt );

	var HaveRef1 = false;
	var ref1pt;
	
	var KeepGoing = true;
	while ( KeepGoing )
	{
		KeepGoing = false;
	
		// Set up bindings.
		
		pointpicker.clearBindings();
		
		if ( !HaveRef1 )
		{
			pointpicker.bindResultPt( ref1linefactory.getInput(1) );			
		}
		else
		{
			pointpicker.bindResultPt( factory.getInput(4) );
			pointpicker.setBasePt( originpt );
		
			moi.ui.commandUI.g_Factory = factory;
			pointpicker.bindFunc( moi.ui.commandUI.OnPoint );
		
			pointpicker.bindResultPt( ref2linefactory.getInput(1) );
		}
			
		while ( 1 )
		{
			if ( !pointpicker.waitForEvent() )
				return;
				
			var makecopy = moi.ui.commandUI.makecopies.value;
			var iscomplete = false;

			if ( pointpicker.event == 'scaleinput' )
			{
				factory.setInput( 2, moi.ui.commandUI.scaleinput.value );
				
				if ( !requireref1 || HaveRef1 )
					iscomplete = true;
			}
			else if ( pointpicker.event == 'finished' )
			{
				if ( !HaveRef1 )
				{
					HaveRef1 = true;
					
					ref1pt = pointpicker.pt;
					
					factory.setInput( 3, ref1pt );

					moi.ui.beginUIUpdate();
					moi.ui.hideUI( 'FirstRefPrompt' );
					moi.ui.showUI( 'SecondRefPrompt' );
		
					if ( requireref1 )
						moi.ui.showUI( 'ScaleFactorOptions' );
		
					moi.ui.endUIUpdate();
					
					// For scale1d, track last point along direction line.
					if ( requireref1 )
						pointpicker.restrictToLinePtPt( originpt, ref1pt, true );

					KeepGoing = true;
					break;
				}
				else
				{
					if ( pointpicker.controlDown )
						makecopy = true;
						
					if ( makecopy )
						moi.ui.removeLastPickedPoint();
						
					iscomplete = true;
				}
			}
			
			if ( iscomplete )
			{
				if ( makecopy )
				{
					factory.reset();
					factory.setInput( 5, true );
					factory.update();
					factory.commit();
					
					factory = moi.command.createFactory( factoryname );
					factory.setInput( 0, objects );
					factory.setInput( 1, input1 );
					factory.setInput( 3, ref1pt );
					factory.setInput( 4, pointpicker.pt );
					factory.update();
					
					KeepGoing = true;
				}
				
				break;
			}
		}
	}

	factory.update();
	factory.commit();
}
